// Code generated by re2c, DO NOT EDIT.
//go:generate re2go -c $INPUT -o $OUTPUT -i
package main

import "errors"

var (
	eSyntax   = errors.New("syntax error")
	eOverflow = errors.New("overflow error")
)

const (
	yycinit = iota
	yycbin
	yycdec
	yychex
	yycoct
)


const u32Limit uint64 = 1<<32

func parse_u32(str string) (uint32, error) {
	var cur, mar int
	result := uint64(0)
	cond := yycinit

	add := func(base uint64, offset byte) {
		result = result * base + uint64(str[cur-1] - offset)
		if result >= u32Limit {
			result = u32Limit
		}
	}

	
{
	var yych byte
	switch (cond) {
	case yycinit:
		goto yyc_init
	case yycbin:
		goto yyc_bin
	case yycdec:
		goto yyc_dec
	case yychex:
		goto yyc_hex
	case yycoct:
		goto yyc_oct
	}
/* *********************************** */
yyc_init:
	yych = str[cur]
	switch (yych) {
	case '0':
		goto yy2
	case '1','2','3','4','5','6','7','8','9':
		goto yy4
	default:
		goto yy1
	}
yy1:
	cur += 1
	{ return 0, eSyntax }
yy2:
	cur += 1
	mar = cur
	yych = str[cur]
	switch (yych) {
	case 'B':
		fallthrough
	case 'b':
		goto yy5
	case 'X':
		fallthrough
	case 'x':
		goto yy7
	default:
		goto yy3
	}
yy3:
	cond = yycoct
	goto yyc_oct
yy4:
	cur += 1
	cur += -1
	cond = yycdec
	goto yyc_dec
yy5:
	cur += 1
	yych = str[cur]
	switch (yych) {
	case '0','1':
		goto yy8
	default:
		goto yy6
	}
yy6:
	cur = mar
	goto yy3
yy7:
	cur += 1
	yych = str[cur]
	switch (yych) {
	case '0','1','2','3','4','5','6','7','8','9':
		fallthrough
	case 'A','B','C','D','E','F':
		fallthrough
	case 'a','b','c','d','e','f':
		goto yy9
	default:
		goto yy6
	}
yy8:
	cur += 1
	cur += -1
	cond = yycbin
	goto yyc_bin
yy9:
	cur += 1
	cur += -1
	cond = yychex
	goto yyc_hex
/* *********************************** */
yyc_bin:
	yych = str[cur]
	switch (yych) {
	case 0x00:
		goto yy11
	case '0','1':
		goto yy13
	default:
		goto yy12
	}
yy11:
	cur += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy12:
	cur += 1
	{ return 0, eSyntax }
yy13:
	cur += 1
	{ add(2, '0');     goto yyc_bin }
/* *********************************** */
yyc_dec:
	yych = str[cur]
	switch (yych) {
	case 0x00:
		goto yy15
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy17
	default:
		goto yy16
	}
yy15:
	cur += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy16:
	cur += 1
	{ return 0, eSyntax }
yy17:
	cur += 1
	{ add(10, '0');    goto yyc_dec }
/* *********************************** */
yyc_hex:
	yych = str[cur]
	switch (yych) {
	case 0x00:
		goto yy19
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy21
	case 'A','B','C','D','E','F':
		goto yy22
	case 'a','b','c','d','e','f':
		goto yy23
	default:
		goto yy20
	}
yy19:
	cur += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy20:
	cur += 1
	{ return 0, eSyntax }
yy21:
	cur += 1
	{ add(16, '0');    goto yyc_hex }
yy22:
	cur += 1
	{ add(16, 'A'-10); goto yyc_hex }
yy23:
	cur += 1
	{ add(16, 'a'-10); goto yyc_hex }
/* *********************************** */
yyc_oct:
	yych = str[cur]
	switch (yych) {
	case 0x00:
		goto yy25
	case '0','1','2','3','4','5','6','7':
		goto yy27
	default:
		goto yy26
	}
yy25:
	cur += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy26:
	cur += 1
	{ return 0, eSyntax }
yy27:
	cur += 1
	{ add(8, '0');     goto yyc_oct }
}

}

func main() {
	test := func(num uint32, str string, err error) {
		if n, e := parse_u32(str); !(n == num && e == err) {
			panic("error")
		}
	}
	test(1234567890, "1234567890\000", nil)
	test(13, "0b1101\000", nil)
	test(0x7fe, "0x007Fe\000", nil)
	test(0644, "0644\000", nil)
	test(0, "9999999999\000", eOverflow)
	test(0, "123??\000", eSyntax)
}
