"""

 @file enum.py

 PaStiX python wrapper to define enums and datatypes

 @copyright 2017-2018 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
                      Univ. Bordeaux. All rights reserved.

 @version 6.0.1
 @author Pierre Ramet
 @author Mathieu Faverge
 @author Louis Poirel
 @date 2018-07-16

This file has been automatically generated with gen_wrappers.py

"""
from ctypes import *
import numpy as np

# Start with __ to prevent broadcast to file importing enum
__pastix_int__ = c_int

class iparm:
    verbose                        = 0
    io_strategy                    = 1
    nnzeros                        = 2
    nnzeros_block_local            = 3
    allocated_terms                = 4
    produce_stats                  = 5
    mc64                           = 6
    ordering                       = 7
    ordering_default               = 8
    scotch_switch_level            = 9
    scotch_cmin                    = 10
    scotch_cmax                    = 11
    scotch_frat                    = 12
    metis_ctype                    = 13
    metis_rtype                    = 14
    metis_no2hop                   = 15
    metis_nseps                    = 16
    metis_niter                    = 17
    metis_ufactor                  = 18
    metis_compress                 = 19
    metis_ccorder                  = 20
    metis_pfactor                  = 21
    metis_seed                     = 22
    metis_dbglvl                   = 23
    amalgamation_lvlblas           = 24
    amalgamation_lvlcblk           = 25
    reordering_split               = 26
    reordering_stop                = 27
    splitting_strategy             = 28
    splitting_levels_projections   = 29
    splitting_levels_kway          = 30
    splitting_projections_depth    = 31
    splitting_projections_distance = 32
    splitting_projections_width    = 33
    min_blocksize                  = 34
    max_blocksize                  = 35
    tasks2d_level                  = 36
    tasks2d_width                  = 37
    allcand                        = 38
    incomplete                     = 39
    level_of_fill                  = 40
    factorization                  = 41
    static_pivoting                = 42
    free_cscuser                   = 43
    schur_fact_mode                = 44
    schur_solv_mode                = 45
    applyperm_ws                   = 46
    refinement                     = 47
    nbiter                         = 48
    itermax                        = 49
    gmres_im                       = 50
    scheduler                      = 51
    thread_nbr                     = 52
    autosplit_comm                 = 53
    gpu_nbr                        = 54
    gpu_memory_percentage          = 55
    gpu_memory_block_size          = 56
    compress_min_width             = 57
    compress_min_height            = 58
    compress_when                  = 59
    compress_method                = 60
    compress_ortho                 = 61
    compress_reltol                = 62
    thread_comm_mode               = 63
    modify_parameter               = 64
    start_task                     = 65
    end_task                       = 66
    float                          = 67
    mtx_type                       = 68
    dof_nbr                        = 69
    size                           = 70

class dparm:
    fill_in            = 0
    epsilon_refinement = 1
    relative_error     = 2
    epsilon_magn_ctrl  = 3
    analyze_time       = 4
    pred_fact_time     = 5
    fact_time          = 6
    solv_time          = 7
    fact_flops         = 8
    fact_thflops       = 9
    fact_rlflops       = 10
    solv_flops         = 11
    solv_thflops       = 12
    solv_rlflops       = 13
    refine_time        = 14
    a_norm             = 15
    compress_tolerance = 16
    compress_min_ratio = 17
    size               = 18

class task:
    Init     = 0
    Ordering = 1
    Symbfact = 2
    Analyze  = 3
    Numfact  = 4
    Solve    = 5
    Refine   = 6
    Clean    = 7

class verbose:
    Not = 0
    No  = 1
    Yes = 2

class io:
    No        = 0
    Load      = 1
    Save      = 2
    LoadGraph = 4
    SaveGraph = 8
    LoadCSC   = 16
    SaveCSC   = 32

class fact_mode:
    Local = 0
    Schur = 1
    Both  = 2

class solv_mode:
    Local     = 0
    Interface = 1
    Schur     = 2

class refine:
    GMRES    = 0
    CG       = 1
    SR       = 2
    BiCGSTAB = 3

class factotype:
    POTRF = 0
    SYTRF = 1
    GETRF = 2
    PXTRF = 3
    HETRF = 4
    LLH   = 0
    LDLT  = 1
    LU    = 2
    LLT   = 3
    LDLH  = 4

class scheduler:
    Sequential = 0
    Static     = 1
    Parsec     = 2
    StarPU     = 3
    Dynamic    = 4

class order:
    Scotch   = 0
    Metis    = 1
    Personal = 2
    PtScotch = 3
    ParMetis = 4

class threadmode:
    Multiple = 1
    Funneled = 2

class error:
    SUCCESS        = 0
    UNKNOWN        = 1
    ALLOC          = 2
    NOTIMPLEMENTED = 3
    OUTOFMEMORY    = 4
    THREAD         = 5
    INTERNAL       = 6
    BADPARAMETER   = 7
    FILE           = 8
    INTEGER_TYPE   = 9
    IO             = 10
    MPI            = 11

class compress_when:
    Never  = 0
    Begin  = 1
    End    = 2
    During = 3

class compress_method:
    SVD   = 0
    PQRCP = 1
    RQRCP = 2
    TQRCP = 3
    RQRRT = 4
    Nbr   = 5

class compress_ortho:
    OrthoCGS       = 0
    OrthoQR        = 1
    OrthoPartialQR = 2

class split:
    Not             = 0
    Kway            = 1
    KwayProjections = 2

class layout:
    RowMajor = 101
    ColMajor = 102

class trans:
    NoTrans   = 111
    Trans     = 112
    ConjTrans = 113

class mtxtype:
    General   = trans.NoTrans
    Symmetric = trans.Trans
    Hermitian = trans.ConjTrans
    SymPosDef = trans.ConjTrans + 1
    HerPosDef = trans.ConjTrans + 2

class uplo:
    Upper      = 121
    Lower      = 122
    UpperLower = 123

class coefside:
    LCoef  = 0
    UCoef  = 1
    LUCoef = 2

class diag:
    NonUnit = 131
    Unit    = 132

class side:
    Left  = 141
    Right = 142

class normtype:
    One       = 171
    Frobenius = 174
    Inf       = 175
    Max       = 177

class dir:
    Forward  = 391
    Backward = 392


