/*
 * Prototypes for all *Op.c files.
 */

/* $Id: ops.h,v 1.17 2005/03/20 20:15:32 demailly Exp $ */

/* Operation flags */
#define ARROWFLAG 1
#define NOTAILFLAG 2
#define HEADFLAG 4
#define TICKFLAG 8
#define MULTIFLAG 16
#define POSITIONFLAG 32
#define MEASUREFLAG 64
#define NOZOOMFLAG 128

/* Various operation modes */
extern int objectMode;
extern char eraseMode, brushMode, centerMode, boxMode, sprayMode, arcMode,
  freehandMode, fillMode, gfillMode, ffillMode, cutMode, splineMode;

/* Various operation parameters */
extern int headType, headSize;
extern double headAngle;
extern int tickType, tickEnds, tickNumber;
extern double tickSize, tickAngle;
extern double brushOpacity;
extern double dynWidth, dynMass, dynDrag;
extern Boolean dynFinish;
extern int sprayRadius, sprayDensity, sprayRate;
extern int boxSize;
extern double boxRatio;
extern int polygonSides;
extern double polygonRatio;
#if FEATURE_FRACTAL
extern int fractalDensity;
#endif
extern double gradientFillAngle, gradientFillVoffset, gradientFillHoffset;
extern double gradientFillPad, gradientFillQuant;
extern int gradientFillTilt;

void MenuLineCheck();

/* arcOp.c */
void *ArcAdd(Widget w);
void ArcRemove(Widget w, void *l);

/* blobOp.c */
void *FreehandAdd(Widget w);
void FreehandRemove(Widget w, void *l);
void *FilledFreehandAdd(Widget w);
void FilledFreehandRemove(Widget w, void *l);

/* boxOp.c */
void DrawBox(Display *dpy, Drawable d, GC gc, XRectangle *rect, Boolean fill);
void *BoxAdd(Widget w);
void BoxRemove(Widget w, void *l);
void *FilledBoxAdd(Widget w);
void FilledBoxRemove(Widget w, void *l);

/* brushOp.c */
void DashSetStyle(char *dashstyle);
void *BrushAdd(Widget w);
void BrushRemove(Widget w, void *l);
void *EraseAdd(Widget w);
void EraseRemove(Widget w, void *l);
void *SmearAdd(Widget w);
void SmearRemove(Widget w, void *l);
void BrushInit(Widget toplevel);
void BrushSelect(Widget w);

/* circleOp.c */
void *CircleAdd(Widget w);
void CircleRemove(Widget w, void *p);
void *FilledCircleAdd(Widget w);
void FilledCircleRemove(Widget w, void *p);
void *EllipseAdd(Widget w);
void EllipseRemove(Widget w, void *p);
void *FilledEllipseAdd(Widget w);
void FilledEllipseRemove(Widget w, void *p);

/* dynPenOp.c */
void *DynPencilAdd(Widget w);
void DynPencilRemove(Widget w, void *p);
void DynPencilSetParameters(double w, double m, double d);
void DynPencilSetFinish(Boolean flag);
Boolean DynPencilGetFinish();

/* fillOp.c */
void *FillAdd(Widget w);
void FillRemove(Widget w, void *l);
void FillSetTolerance(int value);
void *GradientFillAdd(Widget w);
void GradientFillRemove(Widget w, void *l);
void GradientFillSetParameters(double voffset, double hoffset, double pad,
			       double angle, int steps);
void *FractalFillAdd(Widget w);
void FractalFillRemove(Widget w, void *l);

/* fontOp.c */
void *FontAdd(Widget w);
void FontRemove(Widget w, void *p);
void FontChanged(Widget w);

/* freehandOp.c */
void *SelectFreehandAdd(Widget w);
void SelectFreehandRemove(Widget w, void *p);

/* lineOp.c */
void *LineAdd(Widget w);
void LineRemove(Widget w, void *p);
void *ArrowAdd(Widget w);
void ArrowRemove(Widget w, void *p);
void ArrowHeadSetParameters(int t, int s, double a);

/* pencilOp.c */
void *PencilAdd(Widget w);
void PencilRemove(Widget w, void *l);
void *DotPencilAdd(Widget w);
void DotPencilRemove(Widget w, void *l);

/* polygonOp.c */
void *PolygonAdd(Widget w);
void PolygonRemove(Widget w, void *l);
void *FilledPolygonAdd(Widget w);
void FilledPolygonRemove(Widget w, void *p);
void *SelectPolygonAdd(Widget w);
void SelectPolygonRemove(Widget w, void *p);
void *BrokenlineAdd(Widget w);
void BrokenlineRemove(Widget w, void *p);
void PolygonSetParameters(int t, int s, double a);
void PolygonGetParameters(int *t, int *s, double *a);
void CreatePolygonalRegion(Widget w, XPoint *xp, int n);

/* splineOp.c */
void *SplineAdd(Widget w);
void SplineRemove(Widget w, void *p);
void *FilledSplineAdd(Widget w);
void FilledSplineRemove(Widget w, void *p);
void *SelectSplineAdd(Widget w);
void SelectSplineRemove(Widget w, void *p);

/* selectOp.c */
void *SelectBoxAdd(Widget w);
void SelectBoxRemove(Widget w, void *p);
void *SelectEllipseAdd(Widget w);
void SelectEllipseRemove(Widget w, void *p);
Boolean chromaCut(Widget w, XRectangle * r, Pixmap * mask);
void selectKeyPress(Widget w, void * l, XKeyEvent * event, void * info);
void selectKeyRelease(Widget w, void * l, XKeyEvent * event, void * info);

/* sprayOp.c */
void *SprayAdd(Widget w);
void SprayRemove(Widget w, void *p);
