# Shell library containing functions and definitions common to amanda's
# shell scripts and wrappers.

# Include this file as follows:
#   prefix="/usr"
#   exec_prefix="${prefix}"
#   amlibexecdir="/usr/libexec/amanda"
#   . "${amlibexecdir}/amanda-sh-lib.sh"

####
# Configure variables

GREP="/usr/bin/grep"
EGREP="/usr/bin/grep -E"
GETTEXT="/usr/bin/gettext"
GNUPLOT=""
GNUTAR="/usr/bin/gtar"
STAR="/usr/bin/star"
SAMBA_CLIENT="no"
GZIP=""
SORT="/usr/bin/sort"
PERL="/usr/bin/perl"
AWK="gawk"

####
# Set up PATH for finding amanda executables

PATH="/usr/sbin:/usr/libexec/amanda:$PATH"

####
# Gettext

# use as follows:
#   echo `_ "%s: '%s' is not executable" "$myname" "$binpath"`
# NOTE: use a text editor with shell syntax hilighting to avoid
# quoting errors!

if test -n "$GETTEXT"; then
    _() {
	    fmt=`$GETTEXT -d amanda "$1"`
	    shift
	    printf "$fmt" "$@"
    }
else
    _() {
	printf "$@"
    }
fi
